// bump decal.vsh

attribute vec3 Tangent;

uniform mat4 vc0;	// modelViewProj
uniform vec3 vc8;	// sun direction

varying vec3 TangentSpaceSunDir;

void main()
{
	// Transform position
	gl_Position = gl_Vertex * vc0;
	
	// Send vertex color
	gl_FrontColor = gl_Color;

#ifdef TERRAINDIFFUSE
	// Generate coordinates that match terrain
	gl_TexCoord[0].st = gl_Position.xz * vec2(0.0625, -0.0625);
#else
	// Use decal coordinates
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
#endif

	// use decal coordinates for bump
    gl_TexCoord[1].st = gl_MultiTexCoord0.st;
	
	// cross prod to generate binormal in model space -- "w"
	vec3 temp = gl_Normal.zxy * Tangent.yzx;
	vec3 binormal = (gl_Normal.yzx * Tangent.zxy) - temp;

	// transform the light vector by the resulting matrix to get the light dir in tan space
	TangentSpaceSunDir.x = dot( -binormal, vc8 );
	TangentSpaceSunDir.y = dot( Tangent, vc8 );
	TangentSpaceSunDir.z = dot( gl_Normal, vc8 );
}

/*
vs.1.1

dcl_position v0;
dcl_normal v1;
dcl_tangent v2;
dcl_texcoord0 v3;
dcl_color0 v4;

def c20, 0, 1, 0.5, 2
def c21, 0.0625, 0.0625, 0, 0
def c22, 1, -1, 0, 0
def c23, 0.5, 0.5, 0.5, 0.5
def c24, 1, 1, -1, 0


// transform position
dp4 oPos.x, v0, c[0]
dp4 oPos.y, v0, c[1]
dp4 oPos.z, v0, c[2]
dp4 oPos.w, v0, c[3]

// Send vertex color
mov oD0, v4

#ifdef TERRAINDIFFUSE
// Generate coordinates that match terrain
mul r0, v0.xz, c22
mul oT0.xy, r0, c21
#else
// Use decal coordinates
mov oT0.xy, v3
#endif

// use decal coordinates for bump
mov oT1.xy, v3


// cross prod to generate binormal in model space -- "w"
;mul r1, v2.xyz, c24
mov r1, v2
mul r0, v1.zxy, r1.yzx
mad r5, v1.yzx, r1.zxy, -r0


// transform the light vector by the resulting matrix to get the light dir in tan space (into r6)
dp3 r6.x, -r5, c8
dp3 r6.y, r1, c8
dp3 r6.z, v1, c8
mov r6.w, c22.w

// multiply by a half then add half (to be scaled biased back inside pixel shader)
mad oD1, r6, c23, c23
*/
